# 恐竜
恐竜は古代の雄大な生き物で、古代の骨のために養殖することができます。

残念ながら恐竜はずっと前に絶滅してしまったので、今できる最善のことは恐竜の格好をすることです。
この目的のために、新しい恐竜の帽子を受け取りました。

帽子は次のように装備できます
`change_hat(Hats.Dinosaur_Hat)`

残念ながら、広告のようには見えません...

恐竜の帽子を装備し、十分なサボテンを持っている場合、[リンゴ](objects/apple)が自動的に購入され、ドローンの下に配置されます。
ドローンがリンゴの上にいて再び移動すると、リンゴを食べて尻尾が1つ伸びます。余裕があれば、新しいリンゴが購入され、ランダムな場所に配置されます。
リンゴがスポーンしたい場所に何か他のものが植えられている場合、リンゴはスポーンできません。

恐竜の尻尾はドローンの後ろに引きずられ、ドローンが移動した前のタイルを埋めます。ドローンが尻尾の上に移動しようとすると、`move()` は失敗して `False` を返します。
尻尾の最後のセグメントは移動中に邪魔にならないように動くので、その上に移動できます。ただし、ヘビが農場全体を埋め尽くした場合、もう移動できなくなります。したがって、もう移動できないかどうかを確認することで、ヘビが完全に成長したかどうかを確認できます。

リンゴに対して `measure()` を使用すると、次のリンゴの位置がタプルとして返されます。

`next_x, next_y = measure()`

別の帽子を装備して帽子を再び外すと、尻尾が収穫されます。
尻尾の長さの2乗に等しい骨を受け取ります。したがって、長さ `n` の尻尾の場合、`n**2` 個の `Items.Bone` を受け取ります。
例:
長さ 1 => 1 個の骨
長さ 2 => 4 個の骨
長さ 3 => 9 個の骨
長さ 4 => 16 個の骨
長さ 16 => 256 個の骨
長さ 100 => 10000 個の骨

恐竜の帽子は非常に重いため、装備すると `move()` が200 ticksではなく400 ticksかかるようになります。しかし、リンゴを拾うたびに、`move()` が使用するticksの数は3％（切り捨て）減少します。なぜなら、長い尻尾は移動を助けるからです。

次のループは、任意の数のリンゴの後の `move()` が使用するticksの数を表示します:

`ticks = 400
for i in range(100):
    print("ticks after ", i, " apples: ", ticks)
    ticks -= ticks * 0.03 // 1`

恐竜の帽子は1つしかないので、1つのドローンしかかぶれません。

<spoiler=show hint 1>フィールド全体をカバーする同じ経路に沿って移動し続けると、毎回フィールド全体をカバーするヘビを簡単に手に入れることができます。あまり効率的ではありませんが、うまくいきます。
非常に大きな農場を完全に横断するには長い時間がかかる場合があり、実際にはそれほど多くの骨は必要ないかもしれません。`set_world_size()` を自由に使って、農場のサイズをより便利なものに変更してください。</spoiler>